package kalendář;

public class Kalendář 
{
    private static int[] měsíce = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}; 
    private int[] dnyOdPočátkuRoku;
    public Kalendář()
    {
        dnyOdPočátkuRoku = new int[12];
        dnyOdPočátkuRoku[0] = 0;
        int i = 1;
        while(i < dnyOdPočátkuRoku.length)
        {
            dnyOdPočátkuRoku[i] = dnyOdPočátkuRoku[i - 1] + měsíce[i - 1];
            i++;
        }
    }
    
    public static boolean jePřestupný(int rok)
    {
        if(((rok % 4 == 0) && (rok % 100 != 0)) || (rok % 400 == 0))
        {
            return true;
        }
        return false;
    }
    
    public int čísloDne(int den, int měsíc, int rok)
    {
        int d = dnyOdPočátkuRoku[měsíc - 1] + den;
        if(jePřestupný(rok) && (měsíc > 2)) d++;
        return d;
    }
    
//    void výpis()
//    {
//        for(int i : dnyOdPočátkuRoku)
//        {
//            System.out.println(i);
//        }
//    }
}
